/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;

public class Rules
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    String[] headings = new String[]{"ending", "suffix?", "1st", "2nd", "3rd", "1st plural", "2nd plural", "3rd plural"};
    Main parent;
    JTable table;
    JScrollPane tablePane;
    int maxArity = Main.maxColumns;
    int maxSize = 0;
    int gridSize = this.maxArity + 1;
    String[][] allWords = new String[this.maxSize][this.gridSize];
    JTextField accentsText = new JTextField("\u00e1\u00e0\u00e2\u00e4\u00e7\u00e9\u00e8\u00ea\u00eb\u00ee\u00ef\u00f4\u00fa\u00f9\u00fb\u00fc");
    JTextField[] pronounsEntry = new JTextField[this.maxArity];
    JCheckBox pronounsBox = new JCheckBox("Use pronouns");
    JCheckBox shortBox = new JCheckBox("use j' ");
    JButton updateButton = new JButton("Add Space");
    JButton saveButton = new JButton("Save as File");
    JButton cancelButton = new JButton("Return (don't save)");
    JButton resetButton = new JButton("Blank all rules");
    JPanel topPanel = new JPanel();
    JPanel buttonPanel = new JPanel();
    JPanel gridPanel = new JPanel();
    JScrollPane gridPane = new JScrollPane(this.gridPanel, 22, 31);
    Boolean[] suffixes = new Boolean[this.maxSize];
    String[] columnNames = new String[]{"ending", "suffix", "1st", "2nd", "3rd", "1st plural", "2nd plural", "3rd plural"};

    public Rules(Main main) {
        super(new GridLayout(1, 0));
        int n;
        this.parent = main;
        this.topPanel.setLayout(new GridLayout(1, this.headings.length));
        for (n = 0; n < this.headings.length - this.maxArity - 1; ++n) {
            this.topPanel.add(new JLabel(""));
        }
        this.topPanel.add(new JLabel(this.parent.pronounTitle));
        for (n = 0; n < this.maxArity; ++n) {
            this.pronounsEntry[n] = new JTextField("");
            this.topPanel.add(this.pronounsEntry[n]);
        }
        for (n = 0; n < this.headings.length; ++n) {
        }
        this.buttonPanel.setLayout(new GridLayout(2, 3));
        this.buttonPanel.add(this.saveButton);
        this.buttonPanel.add(this.cancelButton);
        this.buttonPanel.add(this.resetButton);
        JLabel jLabel = new JLabel(this.parent.accentsTitle);
        jLabel.setHorizontalTextPosition(4);
        this.buttonPanel.add(this.shortBox);
        this.buttonPanel.add(jLabel);
        this.buttonPanel.add(this.accentsText);
        this.buttonPanel.add(new JLabel(""));
        this.buttonPanel.add(this.pronounsBox);
        this.saveButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.updateButton.addActionListener(this);
        this.resetButton.addActionListener(this);
        this.setVisible(true);
        this.table = new JTable(new MyTableModel());
        int n2 = 12;
        this.table.setFont(new Font("Helvetica", 0, n2));
        this.table.setRowHeight(n2 + 4);
        this.table.setPreferredScrollableViewportSize(new Dimension(700, 570));
        this.table.setFillsViewportHeight(true);
        ((DefaultCellEditor)this.table.getDefaultEditor(String.class)).setClickCountToStart(1);
        this.tablePane = new JScrollPane(this.table);
        this.add(this.tablePane);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == this.resetButton.getText()) {
            if (this.table.getCellEditor() != null) {
                this.table.getCellEditor().stopCellEditing();
            }
            this.resize(0);
            this.resize(10);
        }
        if (string == this.saveButton.getText()) {
            if (this.table.getCellEditor() != null) {
                this.table.getCellEditor().stopCellEditing();
            }
            if (!this.table.isEditing()) {
                this.saveRules();
            }
            return;
        }
        if (string == this.updateButton.getText()) {
            this.resize(this.maxSize + 16);
            return;
        }
        if (string == this.cancelButton.getText()) {
            this.parent.stopRules();
            return;
        }
    }

    void saveFile(FileOutputStream fileOutputStream) throws IOException {
        int n;
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(fileOutputStream));
        if (this.pronounsBox.isSelected()) {
            bufferedWriter.write("yes\n");
        } else {
            bufferedWriter.write("no\n");
        }
        if (this.shortBox.isSelected()) {
            bufferedWriter.write("yes\n");
        } else {
            bufferedWriter.write("no\n");
        }
        String string = this.accentsText.getText() + "\n";
        bufferedWriter.write(string);
        for (n = 0; n < this.maxArity; ++n) {
            bufferedWriter.write(this.pronounsEntry[n].getText() + "\n");
        }
        for (n = 0; n < this.maxSize; ++n) {
            if (this.allWords[n][0] == null || this.allWords[n][0].length() <= 0) continue;
            if (this.suffixes[n] == Boolean.TRUE) {
                bufferedWriter.write("_" + this.allWords[n][0] + "\n");
            } else {
                bufferedWriter.write(this.allWords[n][0] + "\n");
            }
            for (int i = 1; i < this.gridSize; ++i) {
                bufferedWriter.write(this.allWords[n][i] + "\n");
            }
        }
        bufferedWriter.close();
    }

    void saveRules() {
        JFileChooser jFileChooser = this.parent.fcr;
        BSRFileFilter bSRFileFilter = new BSRFileFilter();
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.addChoosableFileFilter(bSRFileFilter);
        int n = jFileChooser.showSaveDialog(this);
        if (n == 0) {
            File file = jFileChooser.getSelectedFile();
            try {
                String string = file.getName();
                String string2 = file.getAbsolutePath();
                if (string.indexOf(Main.ruleExtension) < 1) {
                    string2 = string2 + Main.ruleExtension;
                }
                File file2 = new File(string2);
                FileOutputStream fileOutputStream = new FileOutputStream(string2);
                this.saveFile(fileOutputStream);
                this.parent.rulesFile = file2.getPath();
                String string3 = file2.getName();
                string3 = string3.substring(0, string3.length() - Main.ruleExtension.length());
                this.parent.rulesName.setText(string3);
            }
            catch (IOException iOException) {
                System.out.println(iOException);
            }
        }
    }

    void resize(int n) {
        String[][] stringArray = new String[n][this.gridSize];
        Boolean[] booleanArray = new Boolean[n];
        for (int i = 0; i < n; ++i) {
            int n2;
            if (i < this.maxSize) {
                booleanArray[i] = this.suffixes[i];
            } else {
                booleanArray[i] = new Boolean(false);
                for (n2 = 0; n2 < this.gridSize; ++n2) {
                    stringArray[i][n2] = "";
                }
            }
            for (n2 = 0; n2 < this.gridSize; ++n2) {
                if (i >= this.maxSize) continue;
                stringArray[i][n2] = this.allWords[i][n2];
            }
        }
        this.allWords = stringArray;
        this.maxSize = n;
        this.suffixes = booleanArray;
        this.removeAll();
        this.setLayout(new BorderLayout());
        this.add((Component)this.topPanel, "North");
        this.add((Component)this.buttonPanel, "South");
        this.add((Component)this.tablePane, "Center");
        this.setPreferredSize(new Dimension(720, 450));
        this.revalidate();
    }

    void loadRules(String string) throws IOException {
        this.resize(this.maxSize + 10);
        if (string == null) {
            return;
        }
        File file = new File(string);
        FileReader fileReader = new FileReader(file);
        BufferedReader bufferedReader = new BufferedReader(fileReader);
        String string2 = bufferedReader.readLine();
        boolean bl = false;
        if (string2.equals("yes")) {
            bl = true;
        }
        this.pronounsBox.setSelected(false);
        if (bl) {
            this.pronounsBox.setSelected(true);
        }
        if ((string2 = bufferedReader.readLine()).equals("yes")) {
            // empty if block
        }
        this.shortBox.setSelected(false);
        if (bl) {
            this.shortBox.setSelected(true);
        }
        String string3 = bufferedReader.readLine();
        this.accentsText.setText(string3);
        for (int i = 0; i < this.maxArity; ++i) {
            String string4 = bufferedReader.readLine();
            this.pronounsEntry[i].setText(string4);
        }
        String string5 = bufferedReader.readLine();
        int n = 0;
        while (string5 != null) {
            this.suffixes[n] = Boolean.FALSE;
            if (string5.charAt(0) == '_') {
                string5 = string5.substring(1, string5.length());
                this.suffixes[n] = Boolean.TRUE;
            }
            this.allWords[n][0] = string5;
            for (int i = 0; i < this.maxArity; ++i) {
                this.allWords[n][i + 1] = bufferedReader.readLine();
            }
            if (++n >= this.maxSize) {
                this.resize(this.maxSize * 3 / 2);
            }
            string5 = bufferedReader.readLine();
        }
        bufferedReader.close();
        this.resize(this.maxSize);
    }

    class MyTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        int rv = 0;

        MyTableModel() {
        }

        @Override
        public int getColumnCount() {
            return Rules.this.maxArity + 2;
        }

        @Override
        public int getRowCount() {
            return Rules.this.maxSize;
        }

        @Override
        public String getColumnName(int n) {
            return Rules.this.columnNames[n];
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n2 == 1) {
                return Rules.this.suffixes[n];
            }
            if (n2 > 1) {
                --n2;
            }
            return Rules.this.allWords[n][n2];
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return true;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n == Rules.this.maxSize - 1) {
                Rules.this.resize(Rules.this.maxSize + 5);
            }
            this.fireTableCellUpdated(n, n2);
            if (n2 == 1) {
                Rules.this.suffixes[n] = (Boolean)object;
            } else {
                if (n2 > 1) {
                    --n2;
                }
                Rules.this.allWords[n][n2] = (String)object;
            }
            Rules.this.doLayout();
            Rules.this.revalidate();
            Rules.this.repaint();
        }
    }
}

