/*
 * Decompiled with CFR 0.152.
 */
import java.awt.image.BufferedImage;

public class Horse {
    double xpos;
    double ypos;
    int position;
    int xtarg;
    int ytarg;
    int xhome;
    int yhome;
    BufferedImage[] imageP;
    int status;
    int movement;
    int blinktime;
    boolean onPad;
    int hsize;
    int initx;
    int inity;
    double animFrame = 0.0;
    double animRate = 0.2f;
    int lastFrame;
    double zspeed = 0.0;
    double zpos = 0.0;
    double gravity = -9.8;
    double speed = 0.0;
    double targetSpeed = 0.0;
    double accel = 220.0;
    double decel = -75.0;

    public boolean onPad() {
        return this.onPad;
    }

    public void setPad(boolean bl) {
        this.onPad = bl;
    }

    public int getSize() {
        return this.hsize;
    }

    public Horse(int n, int n2, int n3, BufferedImage[] bufferedImageArray, int n4) {
        this.hsize = n4;
        this.blinktime = (int)(Math.random() * 32.0);
        this.initx = n;
        this.inity = n2;
        this.xpos = n;
        this.ypos = n2;
        this.position = n3;
        this.status = 0;
        this.imageP = bufferedImageArray;
        this.movement = 0;
        this.onPad = false;
        this.animFrame = 2.0;
    }

    public void reset() {
        this.blinktime = (int)(Math.random() * 32.0);
        this.xpos = this.initx;
        this.ypos = this.inity;
        this.status = 0;
        this.movement = 0;
        this.animFrame = 2.0;
    }

    void getFrame() {
        int[] nArray = new int[]{0, 0, 1, 1, 2, 2, 3, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7};
        int[] nArray2 = new int[]{1, 1, 2, 2, 2, 2, 3, 3, 3, 4, 4, 5, 5, 6, 6, 1, 1};
        int[] nArray3 = new int[]{2, 2, 2, 3, 3, 3, 4, 4, 4, 5, 5, 5, 5, 1, 1, 2, 2};
        int n = (int)this.animFrame;
        int n2 = nArray[(n &= 0x7FFFFFFE) % nArray.length];
        if (this.targetSpeed < 10.0) {
            if (this.speed < 80.0) {
                n2 = nArray2[n % nArray.length];
            }
            if (this.speed < 30.0) {
                n2 = nArray3[n % nArray.length];
            }
        }
        this.lastFrame = n2;
    }

    public BufferedImage getImage() {
        this.getFrame();
        return this.imageP[this.lastFrame];
    }

    public double getX() {
        return this.xpos;
    }

    public double getY() {
        return this.ypos;
    }

    private void blink() {
        if (this.blinktime == 0) {
            this.blinktime = 15;
        }
    }

    public boolean isMoving() {
        return this.movement > 0;
    }

    public synchronized void move(int n, int n2) {
        this.xtarg = n - this.imageP[0].getWidth() / 2;
        this.ytarg = n2 - this.imageP[0].getHeight() / 2;
    }

    public void setTarget(int n, int n2) {
        this.xtarg = n - this.imageP[0].getWidth() / 2;
        this.ytarg = n2 - this.imageP[0].getHeight() / 2;
        this.movement = 10;
        ++this.status;
        this.blink();
    }

    public boolean isClicked(int n, int n2) {
        int n3 = 35;
        int n4 = 15;
        int n5 = -10;
        int n6 = -4;
        return this.status == 0 && (double)n > this.xpos + (double)n3 + (double)n6 && (double)n < this.xpos + (double)this.imageP[0].getWidth() - (double)n3 + (double)n6 && (double)n2 > this.ypos + (double)n4 + (double)n5 && (double)n2 < this.ypos + (double)this.imageP[0].getHeight() - (double)n4 + (double)n5;
    }

    public double getZ() {
        double d = this.zpos;
        if (d < 0.1) {
            d += Math.random() * this.speed / 14070.0;
        }
        return d * 122.8;
    }

    public double getZP() {
        double d = this.zpos;
        return d;
    }

    void jumping(double d) {
        double d2 = this.zspeed * d + this.gravity * d * d / 2.0;
        this.zspeed += this.gravity * d;
        this.zpos += d2;
        if (this.zpos < 0.0) {
            this.zpos = 0.0;
            this.zspeed = 0.0;
        }
    }

    public double getSpeed() {
        return this.speed;
    }

    public void setSpeed(double d) {
        this.targetSpeed = d;
    }

    public void collide(double d) {
        this.speed *= d;
    }

    public void jump() {
        if (this.speed > 50.0 && this.zpos < 1.0E-4 && this.zspeed < 1.0) {
            this.zspeed = 4.0;
        }
    }

    public void jumplet() {
        if (this.speed > 50.0 && this.zpos < 1.0E-4 && this.zspeed < 0.25) {
            this.zspeed = 0.95;
        }
    }

    public void updateHorse(double d) {
        this.getFrame();
        this.jumping(d);
        if (this.targetSpeed > this.speed) {
            this.speed += this.accel * d;
            if (this.targetSpeed < this.speed) {
                this.speed = this.targetSpeed;
            }
        } else if (this.targetSpeed < this.speed) {
            this.speed += this.decel * d;
            if (this.targetSpeed > this.speed) {
                this.speed = this.targetSpeed;
            }
        }
        this.xpos += this.speed * d * 3.0 / 2.0;
        if (this.zpos > 0.1) {
            if (this.lastFrame != 7) {
                this.animFrame += this.speed * d * this.animRate;
            }
        } else if (this.speed < 24.0) {
            if (this.lastFrame != 2) {
                this.animFrame += 15.0 * d;
            }
        } else {
            this.animFrame += this.speed * d * this.animRate;
        }
    }

    public void goHome() {
        if (this.status > 0) {
            return;
        }
        this.xtarg = this.xhome;
        this.ytarg = this.yhome;
        this.movement = 96;
    }

    public void grabbed() {
        this.blink();
        this.movement = 14;
    }
}

