/*
 * Decompiled with CFR 0.152.
 */
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;

public class Game
implements Sendable {
    int APPWIDTH = 1;
    int APPHEIGHT = 1;
    public double abandonTime = 12.0;
    BufferedImage[] allCards;
    int round = 0;
    int roundSize = 25;
    int maxRounds = 37;
    int[] gameCards;
    int numWords;
    int status_off = 0;
    int status_up = 1;
    int status_on = 2;
    int status_down = 3;
    int status_done = 4;
    int status_next = 5;
    int status_end = 6;
    boolean received;
    int status = this.status_off;
    double gameTime = 0.0;
    double waitTime = 0.75;
    int numHorses;
    double onTime = 0.0;
    int cardY;
    Connect gc;
    double waiting = 0.0;
    double[] receiveTimes;
    double myTime = 0.0;
    double sentTime;
    double currentTime = 0.0;
    int resend = 0;
    String[] results;
    int numLines;
    String ended;
    String[] names;
    double ntimer = 0.0;
    double maxTime = 5.0;
    double clickTime;
    public Logger logger;
    int maxTextLength = 21;
    String enterText = "";
    int targetY;
    double onSpeed = 540.0;
    int[] places = new int[32];
    Color tBoxCol = new Color(175, 155, 40);
    Color boxCol = new Color(200, 180, 50);
    Color edgeCol = new Color(150, 130, 30);
    int edge = 2;
    boolean[] inplace = new boolean[255];
    HorseClient hc;
    double ratio = 0.7071135624381276;
    int cardWidth = this.APPWIDTH / (this.roundSize + 2);
    int cardHeight = (int)((double)this.cardWidth * this.ratio);
    FontMetrics fontMetrics;
    Font myFont;
    Color textColour = new Color(5, 1, 5);
    Color shadowColour = new Color(125, 120, 125);
    Color darkShadowColour = new Color(25, 30, 26);
    Color whiteColour = new Color(225, 229, 225);
    Image[] frontImages = new Image[2];
    BufferedImage[] cardFronts;
    String dirname = "files/";
    Color transPink = new Color(255, 0, 255);
    int arity;
    String[] pronouns;
    String[] verbs;
    String[][] answers;
    int[] boatTypes;
    String accentsl;
    String wonText;
    String lostText;
    int gameMode = 0;
    int numPronouns = 6;
    String serverName = "http://www.scabbydog.co.uk/";

    public int getNumber() {
        if (this.gc == null) {
            return 0;
        }
        return this.gc.getNumber();
    }

    void sendName() {
        String[] stringArray = new String[2];
        stringArray[1] = " ," + this.getNumber() + "," + this.names[this.getNumber()];
        if (this.gc != null) {
            this.gc.sendArray(stringArray);
        }
        for (int i = 0; i < this.numHorses; ++i) {
            if (this.gc == null || !this.gc.dummy(i)) continue;
            stringArray[1] = " ," + i + ",Computer";
            this.gc.sendArray(stringArray);
        }
    }

    void sendTime(double d) {
        this.myTime = d;
        String[] stringArray = new String[3];
        if (this.round >= this.maxRounds) {
            return;
        }
        this.sentTime = this.currentTime;
        if (this.gc != null) {
            stringArray[1] = "" + this.gc.getNumber();
            stringArray[2] = "" + d;
            this.gc.sendArray(stringArray);
        }
        for (int i = 0; i < this.numHorses; ++i) {
            double d2 = 1.2 + Math.random() * this.maxTime * 4.0 / 3.0;
            if (this.gc == null || !this.gc.dummy(i)) continue;
            stringArray[1] = "" + i;
            stringArray[2] = "" + d2;
            this.gc.sendArray(stringArray);
        }
        this.received = false;
        this.hc.hasSent();
    }

    public void getTimes(double d) {
        int n;
        if (this.gc == null) {
            for (int i = 0; i < 4; ++i) {
                this.receiveTimes[i] = 1.0 + Math.random() * this.maxTime * 4.0 / 3.0;
            }
            this.receiveTimes[this.hc.myHorse] = this.myTime;
            this.received = true;
            return;
        }
        String[] stringArray = this.gc.getArrayAsync(d);
        if (this.currentTime - this.sentTime > this.abandonTime) {
            this.abandon(stringArray);
        }
        if (stringArray == null) {
            return;
        }
        if (stringArray.length < this.numLines) {
            return;
        }
        int n2 = 0;
        for (n = 0; n < this.numHorses; ++n) {
            this.receiveTimes[n] = this.maxTime + 0.1;
        }
        for (n = 0; n < this.numLines; n += 2) {
            double d2;
            int n3 = Integer.parseInt(stringArray[n]);
            this.receiveTimes[n3] = d2 = Double.parseDouble(stringArray[n + 1]);
            n2 += (2 + n3) * (2 + n3);
        }
        this.gc.received(stringArray, this.numLines);
        this.received = true;
    }

    public void abandon(String[] stringArray) {
        if (stringArray == null) {
            this.gc = null;
            return;
        }
        if (this.currentTime - this.sentTime > this.abandonTime * 3.0 / 2.0) {
            this.gc = null;
        }
        if (stringArray.length > 2 && stringArray.length <= this.numHorses * 2) {
            this.numLines = stringArray.length;
        }
    }

    public void setName(String string) {
        if (string.length() < 1) {
            string = "Horse " + (this.getNumber() + 1);
        }
        this.names[this.getNumber()] = string;
    }

    @Override
    public void sendInitial() {
        if (this.gc == null) {
            return;
        }
        this.numWords = this.roundSize * this.maxRounds;
        String[] stringArray = new String[this.numWords + 1];
        String[] stringArray2 = new String[this.numWords];
        for (int i = 0; i < this.numWords; ++i) {
            stringArray[i + 1] = "" + this.gameCards[i];
            stringArray2[i] = stringArray[i + 1];
        }
        if (this.gc == null) {
            return;
        }
        this.gc.sendArray(stringArray);
        this.gc.received(stringArray2, this.numWords);
        this.sendName();
    }

    @Override
    public int getInitial(double d) {
        this.numWords = this.roundSize * this.maxRounds;
        if (this.gc == null) {
            return 0;
        }
        this.waiting = 0.0;
        String[] stringArray = this.gc.getArray(d);
        if (stringArray == null) {
            return 0;
        }
        if (stringArray.length > 0 && stringArray[0] != null && stringArray[0].equals("0000")) {
            this.gc.received(stringArray, 1);
            return 0;
        }
        if (stringArray.length < this.numWords) {
            if (stringArray.length > 0 && stringArray[0].contains("-")) {
                return -1;
            }
            return 0;
        }
        int[] nArray = new int[this.numWords];
        for (int i = 0; i < this.numWords; ++i) {
            nArray[i] = Integer.parseInt(stringArray[i]);
        }
        this.gameCards = nArray;
        this.gc.gotInitial();
        this.gc.received(stringArray, this.numWords);
        this.sendName();
        return 1;
    }

    public void startNow() {
        if (this.gc != null) {
            this.gc.startNow();
        }
    }

    public Game(int n, int n2, int n3, HorseClient horseClient, String string, boolean bl) {
        this.hc = horseClient;
        this.numHorses = n3;
        this.APPWIDTH = n;
        this.APPHEIGHT = n2;
        this.status = this.status_off;
        this.cardY = this.APPHEIGHT + 50;
        this.round = 0;
        this.received = false;
        this.receiveTimes = new double[this.numHorses];
        this.numWords = this.roundSize * this.maxRounds;
        this.serverName = Server.getName(horseClient);
        while (!this.getWords(string)) {
            try {
                Thread.sleep(2500L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.setCards();
        this.gc = null;
        if (!bl) {
            this.gc = new Connect(horseClient, string, this);
        }
        this.numLines = this.numHorses * 2;
        this.currentTime = 0.0;
        this.names = new String[this.numHorses];
    }

    public void cardsOn(int n) {
        this.round = n;
        this.cardY = this.APPHEIGHT + 50;
        this.status = this.status_next;
        this.gameTime = 0.0;
        this.received = false;
    }

    public void cardsOn() {
        if (this.status == this.status_end) {
            return;
        }
        this.enterText = "";
        if (this.status == this.status_done || this.status == this.status_off) {
            ++this.round;
            this.cardY = this.APPHEIGHT + 50;
            this.status = this.status_next;
            this.gameTime = 0.0;
            if (this.round >= this.maxRounds) {
                this.sendResults();
                this.status = this.status_done;
            }
            this.received = false;
        }
    }

    private void sendResults() {
        int[] nArray = this.hc.getOrder();
        String[] stringArray = new String[2];
        stringArray[1] = "" + nArray[0];
        for (int i = 1; i < this.numHorses; ++i) {
            stringArray[1] = stringArray[1] + "," + nArray[i];
        }
        this.ended = stringArray[1];
        if (this.gc == null) {
            return;
        }
        this.gc.sendArray(stringArray);
    }

    public String[] getNames() {
        return this.names;
    }

    @Override
    public boolean setNames(double d) {
        int n;
        if (this.gc == null) {
            return true;
        }
        int n2 = 0;
        for (int i = 0; i < this.numHorses; ++i) {
            if (this.names[i] == null) continue;
            ++n2;
        }
        if (n2 == this.numHorses) {
            return true;
        }
        this.ntimer = this.waitTime;
        String[] stringArray = this.gc.getArrayAsync(d);
        if (stringArray == null) {
            return false;
        }
        if (stringArray.length < 1) {
            return false;
        }
        for (n = 0; n < stringArray.length; ++n) {
            String string = stringArray[n];
            if (string.charAt(0) != ' ') continue;
            String[] stringArray2 = string.split(",");
            int n3 = Integer.parseInt(stringArray2[1]);
            this.names[n3] = stringArray2[2];
        }
        n2 = 0;
        for (n = 0; n < this.numHorses; ++n) {
            if (this.names[n] == null) continue;
            ++n2;
        }
        if (n2 != this.numHorses) {
            return false;
        }
        this.gc.received(stringArray, stringArray.length);
        return true;
    }

    public String[] getFinishOrder(double d) {
        String[] stringArray = new String[]{this.ended};
        if (this.gc == null) {
            return stringArray;
        }
        String[] stringArray2 = this.gc.getArrayAsync(d);
        if (stringArray2 == null) {
            return null;
        }
        if (stringArray2.length < 1) {
            return null;
        }
        this.gc.received(stringArray2, 1);
        return stringArray2;
    }

    public Connect getConnection() {
        return this.gc;
    }

    public void cardsOff() {
        this.status = this.status_down;
    }

    public double getTime() {
        return this.clickTime;
    }

    public void ended() {
        if (this.status == this.status_end) {
            return;
        }
        this.sendResults();
        this.status = this.status_end;
    }

    public boolean gameOver() {
        if (this.status == this.status_end) {
            return true;
        }
        return this.status == this.status_done && this.round >= this.maxRounds - 1;
    }

    public boolean gameended() {
        return this.status == this.status_end;
    }

    public boolean newFence(double d) {
        this.getTimes(d);
        if (!this.received) {
            return false;
        }
        if (this.status != this.status_done) {
            return false;
        }
        this.received = false;
        return true;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public double getMax() {
        return this.maxTime;
    }

    public double[] getJumps() {
        return this.receiveTimes;
    }

    public void typed(char c) {
        if (this.round >= this.maxRounds) {
            return;
        }
        if (this.gameMode != 1) {
            return;
        }
        if (this.status == this.status_on) {
            if (c == '\b') {
                if (this.enterText.length() > 0) {
                    this.enterText = this.enterText.substring(0, this.enterText.length() - 1);
                }
                return;
            }
            if (c == '\n') {
                this.clickTime = this.maxTime + 0.01;
                int n = this.round * this.roundSize;
                int n2 = this.gameCards[n];
                int n3 = this.gameCards[n + 1];
                if (this.answers[n3 -= this.numPronouns][n2].toLowerCase().equals(this.enterText.toLowerCase())) {
                    this.clickTime = this.onTime;
                    String string = "" + this.onTime;
                    if (string.length() > 5) {
                        string = string.substring(0, 5);
                    }
                    this.logger.logMessage("RIGHT! " + this.answers[n3][n2].toLowerCase() + " in " + string);
                } else {
                    String string = "" + this.onTime;
                    if (string.length() > 5) {
                        string = string.substring(0, 5);
                    }
                    this.logger.logMessage("WRONG! " + this.enterText + " should be " + this.answers[n3][n2].toLowerCase() + " in " + string);
                }
                this.status = this.status_down;
                this.sendTime(this.clickTime);
                return;
            }
            if (this.enterText.length() < this.maxTextLength) {
                this.enterText = this.enterText + c;
            }
        }
    }

    public void clicked(int n, int n2) {
        if (this.round >= this.maxRounds) {
            return;
        }
        if (this.status == this.status_on) {
            int n3;
            if (n2 < this.targetY) {
                return;
            }
            if (this.gameMode == 1) {
                if (n2 < this.APPHEIGHT * 14 / 16) {
                    return;
                }
                int n4 = this.APPWIDTH - (this.cardWidth * 2 + this.cardWidth);
                int n5 = (this.APPWIDTH - n4) / 2;
                if (n < (n5 += this.cardWidth * 5 / 4)) {
                    return;
                }
                int n6 = -1;
                String string = this.accentsl;
                int n7 = 0;
                for (int i = 0; i < string.length(); ++i) {
                    n7 = n4 / string.length();
                    if (n <= n5 + n7 * i) continue;
                    n6 = i;
                }
                if (n6 > -1) {
                    this.enterText = this.enterText + "" + string.charAt(n6);
                }
                return;
            }
            int n8 = 0;
            for (n3 = 1; n3 < this.roundSize; ++n3) {
                if (n <= this.places[n3]) continue;
                n8 = n3;
            }
            if (n8 > 0) {
                this.clickTime = this.maxTime + 0.01;
                n3 = this.round * this.roundSize;
                int n9 = this.gameCards[n3 + n8] % this.numPronouns;
                int n10 = this.gameCards[n3 + n8] - this.numPronouns;
                int n11 = n10 % this.numPronouns;
                int n12 = n10 / this.numPronouns;
                int n13 = this.gameCards[n3];
                if (n9 == this.gameCards[n3]) {
                    this.clickTime = this.onTime;
                    String string = "" + this.onTime;
                    if (string.length() > 5) {
                        string = string.substring(0, 5);
                    }
                    this.logger.logMessage("RIGHT! " + this.answers[n12][n11] + " in " + string);
                } else {
                    String string = "" + this.onTime;
                    if (string.length() > 5) {
                        string = string.substring(0, 5);
                    }
                    this.logger.logMessage("WRONG! " + this.answers[n12][n11] + " is not " + this.pronouns[n13] + " in " + string);
                }
                this.status = this.status_down;
                this.sendTime(this.clickTime);
            }
        }
    }

    void processGame(double d) {
        this.currentTime += d;
        this.targetY = this.APPHEIGHT * 19 / 24;
        if (this.status == this.status_next && this.gameTime > this.waitTime) {
            this.status = this.status_up;
        }
        if (this.status == this.status_up) {
            this.cardY -= (int)(d * this.onSpeed);
            if (this.cardY < this.targetY) {
                this.cardY = this.targetY;
                this.status = this.status_on;
            }
        }
        if (this.status == this.status_down) {
            this.cardY += (int)(d * this.onSpeed);
            if (this.cardY > this.APPHEIGHT + 50) {
                this.status = this.status_done;
            }
        }
        if (this.status == this.status_on) {
            this.onTime += d;
            if (this.onTime > this.maxTime) {
                this.clickTime = this.maxTime + 0.01;
                this.sendTime(this.clickTime);
                this.status = this.status_down;
                int n = this.round * this.roundSize;
                int n2 = this.gameCards[n];
                int n3 = this.gameCards[n + 1] - this.numPronouns;
                if (this.gameMode == 0) {
                    this.logger.logMessage("OUTOFTIME! " + this.pronouns[n2]);
                } else {
                    this.logger.logMessage("OUTOFTIME! " + this.answers[n3][n2]);
                }
            }
        } else {
            this.onTime = 0.0;
        }
        this.gameTime += d;
    }

    public void processConnection(double d) {
        if (this.gc != null) {
            this.gc.process(d);
        }
    }

    public double getWaiting() {
        if (this.gc != null) {
            return this.waiting;
        }
        return 0.0;
    }

    public void sendName(String string) {
        if (this.gc != null) {
            this.gc.sendName(string);
        }
    }

    public String getOpponent(double d) {
        if (this.gc == null) {
            return " ";
        }
        String string = this.gc.getName(d);
        return string;
    }

    public String getGameID() {
        if (this.gc == null) {
            return "own game";
        }
        return "game id " + this.gc.getPartnerName();
    }

    public int connectStatus() {
        if (this.gc == null) {
            return 11;
        }
        return this.gc.getStatus();
    }

    public void disconnect() {
        this.gc = null;
    }

    public boolean connected() {
        return this.gc != null;
    }

    void setCards() {
        if (this.gameCards == null) {
            int n;
            int n2;
            int n3 = 0;
            for (n2 = 0; n2 < this.arity; ++n2) {
                for (n = 0; n < this.numPronouns; ++n) {
                    if (this.verbs[n2].length() <= 0 && this.answers[n2][n].length() <= 0) continue;
                    n3 = n2 + 1;
                }
            }
            this.gameCards = new int[this.roundSize * this.maxRounds];
            for (n2 = 0; n2 < this.maxRounds; ++n2) {
                int n4;
                int n5;
                int n6;
                int n7;
                n = n2 * this.roundSize;
                int n8 = 0;
                int n9 = 0;
                while (n9 == 0) {
                    n8 = (int)(Math.random() * (double)this.numPronouns);
                    if (n2 > 0 && n8 == this.gameCards[n - this.roundSize]) {
                        n8 = (this.gameCards[n] + 1) % this.numPronouns;
                    }
                    for (n7 = 0; n7 < this.arity; ++n7) {
                        n9 += this.answers[n7][n8].length();
                    }
                }
                if (this.gameMode == 1) {
                    n7 = (int)(Math.random() * (double)n3);
                    while (this.answers[n7][n8].length() == 0) {
                        n7 = (int)(Math.random() * (double)n3);
                    }
                    this.gameCards[n] = n2 % this.numPronouns;
                    this.gameCards[n + 1] = this.numPronouns + n7;
                    if (n2 > 0) {
                        this.gameCards[n + 1] = this.gameCards[1];
                    }
                    this.maxRounds = this.numPronouns;
                    if (this.answers[n7][n2 % this.numPronouns] != null && this.answers[n7][n2 % this.numPronouns].length() != 0) continue;
                    this.maxRounds = n2;
                    break;
                }
                this.gameCards[n] = n8;
                for (n7 = 1; n7 < this.roundSize - 1; ++n7) {
                    n6 = 0;
                    n5 = (int)(Math.random() * (double)this.arity);
                    n4 = (int)(Math.random() * (double)this.numPronouns);
                    int n10 = 0;
                    while (n6 == 0) {
                        int n11;
                        n5 = (int)(Math.random() * (double)n3);
                        n4 = (int)(Math.random() * (double)this.numPronouns);
                        int n12 = this.gameCards[n];
                        n6 = 1;
                        if (this.answers[n5][n4].length() < 1) {
                            n6 = 0;
                        }
                        for (n11 = 0; n11 < this.arity; ++n11) {
                            if (!this.answers[n11][n12].equals(this.answers[n5][n4])) continue;
                            n6 = 0;
                        }
                        for (n11 = 1; n11 < n7; ++n11) {
                            int n13 = this.gameCards[n + n11] / this.numPronouns - 1;
                            int n14 = this.gameCards[n + n11] % this.numPronouns;
                            if (this.answers[n13][n14].equals(this.answers[n5][n4])) {
                                n6 = 0;
                            }
                            if (n10 >= 500 || n14 != n4) continue;
                            n6 = 0;
                        }
                        if (++n10 <= 1000) continue;
                        System.out.println("abort error" + this.numPronouns);
                        n6 = 1;
                        n5 = -3;
                    }
                    this.gameCards[n + n7] = (n5 + 1) * this.numPronouns + n4;
                }
                n7 = (int)(Math.random() * (double)(this.roundSize - 1));
                n6 = this.gameCards[n];
                n5 = (int)(Math.random() * (double)n3);
                while (this.answers[n5][n6].length() < 1) {
                    n5 = (int)(Math.random() * (double)n3);
                }
                if (n7 == this.roundSize - 2) {
                    this.gameCards[n + n7 + 1] = (n5 + 1) * this.numPronouns + n6;
                    continue;
                }
                n4 = this.gameCards[n + n7 + 1];
                this.gameCards[n + n7 + 1] = (n5 + 1) * this.numPronouns + n6;
                this.gameCards[n + this.roundSize - 1] = n4;
            }
        }
    }

    void drawCards(Graphics2D graphics2D) {
        if (this.round >= this.maxRounds) {
            return;
        }
        graphics2D.setColor(this.hc.m_clrBg);
        graphics2D.fillRect(0, this.APPHEIGHT * 3 / 4 - 1, this.APPWIDTH, this.APPHEIGHT / 4 + 4);
        for (int i = 0; i < this.roundSize; ++i) {
            int n = this.gameCards[this.roundSize * this.round + i];
            int n2 = i * (this.APPWIDTH / (this.roundSize + 1));
            if (i > 0) {
                n2 += this.APPWIDTH / (2 * this.roundSize + 1);
            }
            if (this.gameMode == 1) {
                n2 = this.cardWidth / 4;
                if (i > 0) {
                    n2 = this.cardWidth * 3 / 2;
                }
            }
            this.places[i] = n2;
            if (n < 0) continue;
            graphics2D.drawImage((Image)this.allCards[n], n2, this.cardY, null);
        }
        if (this.gameMode == 1) {
            this.drawKeyboard(this.cardY, graphics2D);
        }
    }

    void drawKeyboard(int n, Graphics2D graphics2D) {
        int n2 = this.APPHEIGHT / 30;
        Font font = new Font("Comic Sans MS", 0, n2);
        int n3 = n2 * 2;
        Font font2 = new Font("Comic Sans MS", 0, n3);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        int n4 = this.APPWIDTH - (this.cardWidth * 2 + this.cardWidth);
        String string = this.accentsl;
        if (this.gameMode != 1) {
            return;
        }
        int n5 = n;
        int n6 = n4;
        int n7 = (this.APPWIDTH - n4) / 2;
        n7 += this.cardWidth * 5 / 4;
        if (string == null) {
            string = "";
        }
        int n8 = this.APPHEIGHT / 16;
        if (string.length() > 0) {
            n6 = n4 / string.length();
            n5 = n5 + this.APPHEIGHT / 4 - n8 * 5 / 2;
            graphics2D.setColor(this.edgeCol);
            graphics2D.fillRect(n7 - this.edge, n5 - this.edge, n4 + this.edge + this.edge, n8 + this.edge + this.edge);
            graphics2D.setColor(this.tBoxCol);
            graphics2D.fillRect(n7, n5, n4, n8);
            graphics2D.setFont(font);
            graphics2D.setColor(this.textColour);
            for (int i = 0; i < string.length(); ++i) {
                int n9 = n6 / 2;
                String string2 = "" + string.charAt(i);
                graphics2D.drawString(string2, n9 + n7 + n6 * i, n5 + n2 * 3 / 2);
            }
            graphics2D.setColor(this.edgeCol);
            graphics2D.fillRect(n7 - this.edge, (n5 -= n8 * 10 / 4) - this.edge + n8 - n8 / 2, n4 + this.edge + this.edge, n8 + this.edge + this.edge + n8 / 2);
            graphics2D.setColor(this.tBoxCol);
            graphics2D.fillRect(n7, n5 + n8 - n8 / 2, n4, n8 + n8 / 2);
        } else {
            graphics2D.setColor(this.edgeCol);
            graphics2D.fillRect(n7 - this.edge - this.edge, n5 - this.edge + n8 - n8 / 2, n4 + this.edge + this.edge, n8 + this.edge + this.edge + n8 / 2);
            graphics2D.setColor(this.tBoxCol);
            graphics2D.fillRect(n7 - this.edge, n5 + n8 - n8 / 2, n4, n8 + n8 / 2);
        }
        graphics2D.setColor(this.textColour);
        graphics2D.setFont(font2);
        String string3 = this.enterText;
        if (this.currentTime % 0.7 > 0.35) {
            string3 = string3 + "_";
        }
        n5 = n + n3 * 2 / 3;
        if (string.length() == 0) {
            n5 += n8;
        }
        graphics2D.drawString(string3, n7 += this.cardWidth / 8, n5);
    }

    public void makeImages(String string) {
        int n;
        int n2;
        this.numHorses = 4;
        double d = 0.7071135624381276;
        this.cardWidth = this.APPWIDTH / (this.roundSize + 2);
        this.cardHeight = (int)((double)this.cardWidth * d);
        if (this.cardHeight > this.APPHEIGHT * 4 / 24) {
            this.cardHeight = this.APPHEIGHT * 4 / 24;
            this.cardWidth = (int)((double)this.cardHeight / d);
        }
        for (n2 = 0; n2 < 2; ++n2) {
            this.frontImages[n2] = this.hc.loadImage(this.dirname + "cardf" + n2 + ".png");
        }
        n2 = 0;
        this.allCards = new BufferedImage[this.arity * this.numPronouns + this.numPronouns];
        for (n = 0; n < this.numPronouns; ++n) {
            this.allCards[n2++] = this.makeTransparentText(this.transPink, this.frontImages[0], this.pronouns[n], this.cardWidth, this.cardHeight);
        }
        if (this.gameMode == 0) {
            for (n = 0; n < this.arity; ++n) {
                for (int i = 0; i < this.numPronouns; ++i) {
                    this.allCards[n2++] = this.makeTransparentText(this.transPink, this.frontImages[1], this.answers[n][i], this.cardWidth, this.cardHeight);
                }
            }
        } else {
            for (n = 0; n < this.arity; ++n) {
                this.allCards[n2++] = this.makeTransparentText(this.transPink, this.frontImages[1], this.verbs[n], this.cardWidth, this.cardHeight);
            }
        }
    }

    public BufferedImage makeTransparentText(Color color, Image image, String string, int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6 = 0;
        Image image2 = image;
        BufferedImage bufferedImage = this.hc.config.createCompatibleImage(image2.getWidth(null), image2.getHeight(null), 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setComposite(AlphaComposite.Src);
        graphics2D.drawImage(image2, 0, 0, null);
        for (n5 = 0; n5 < bufferedImage.getHeight(); ++n5) {
            for (n4 = 0; n4 < bufferedImage.getWidth(); ++n4) {
                if (bufferedImage.getRGB(n4, n5) != color.getRGB()) continue;
                bufferedImage.setRGB(n4, n5, 9378844);
            }
        }
        image2 = bufferedImage;
        bufferedImage = this.hc.config.createCompatibleImage(n, n2, 2);
        graphics2D = bufferedImage.createGraphics();
        graphics2D.setComposite(AlphaComposite.Src);
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        graphics2D.drawImage(image2, 0, n6, n, n2, null);
        n5 = n;
        n4 = n2;
        int n7 = 1;
        int n8 = n5 + 1;
        int n9 = 0;
        int n10 = 0;
        int n11 = 65;
        String string2 = null;
        while ((n8 > n5 * 14 / 16 || n9 > n4 * 10 / 16) && --n11 >= 6) {
            this.myFont = new Font("Comic Sans MS", 0, n11);
            graphics2D.setFont(this.myFont);
            this.fontMetrics = graphics2D.getFontMetrics();
            n7 = this.fontMetrics.stringWidth(string);
            n9 = this.fontMetrics.getHeight();
            n10 = n4 / 2 + this.fontMetrics.getAscent() / 4;
            n8 = n7;
        }
        if (string.length() > 9 && string.indexOf(32) > 0) {
            n3 = string.indexOf(32);
            int n12 = Math.max(n3, string.length() - n3);
            int n13 = n3;
            while (n3 > 0) {
                int n14 = Math.max(n3, string.length() - n3);
                if (n14 < n12) {
                    n12 = n14;
                    n13 = n3;
                }
                n3 = string.indexOf(32, n3 + 1);
            }
            string2 = string.substring(n13 + 1, string.length());
            string = string.substring(0, n13);
            n11 = 65;
            n8 = n5 + 1;
            while ((n8 > n5 * 14 / 16 || n9 > n4 * 8 / 16) && --n11 >= 6) {
                this.myFont = new Font("Comic Sans MS", 0, n11);
                graphics2D.setFont(this.myFont);
                this.fontMetrics = graphics2D.getFontMetrics();
                n7 = this.fontMetrics.stringWidth(string2);
                n9 = this.fontMetrics.getHeight();
                n8 = n7;
                n7 = this.fontMetrics.stringWidth(string);
                n10 = n4 / 2 + this.fontMetrics.getAscent() / 4;
                if (n7 <= n8) continue;
                n8 = n7;
            }
        }
        n3 = (n5 - n7) / 2;
        n10 += 4;
        if (string2 != null) {
            n10 -= this.fontMetrics.getAscent() / 2;
        }
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graphics2D.setColor(this.shadowColour);
        graphics2D.drawString(string, n3 + 2, n10 + 2);
        graphics2D.setColor(this.textColour);
        graphics2D.drawString(string, n3, n10);
        if (string2 != null) {
            n7 = this.fontMetrics.stringWidth(string2);
            n3 = (n5 - n7) / 2;
            n10 = n10 + this.fontMetrics.getAscent() + 1;
            graphics2D.setColor(this.shadowColour);
            graphics2D.drawString(string2, n3 + 2, n10 + 2);
            graphics2D.setColor(this.textColour);
            graphics2D.drawString(string2, n3, n10);
        }
        graphics2D.dispose();
        return bufferedImage;
    }

    int getInt(BufferedReader bufferedReader) throws IOException {
        String string = bufferedReader.readLine();
        int n = Integer.parseInt(string);
        return n;
    }

    void getVersionSpecific(String string, BufferedReader bufferedReader) throws IOException {
        this.gameMode = 0;
        if (string.equals("1.2")) {
            this.gameMode = this.getInt(bufferedReader);
        }
        if (string.contains("1.")) {
            this.maxRounds = this.getInt(bufferedReader);
            this.roundSize = this.getInt(bufferedReader) + 1;
            this.maxTime = this.getInt(bufferedReader);
        }
        if (this.gameMode == 1) {
            this.roundSize = 2;
        }
    }

    void getData(BufferedReader bufferedReader) throws IOException {
        int n;
        int n2;
        String string = bufferedReader.readLine();
        if (string.contains(".")) {
            this.getVersionSpecific(string, bufferedReader);
            string = bufferedReader.readLine();
        }
        this.arity = Integer.parseInt(string);
        this.numPronouns = this.getInt(bufferedReader);
        this.verbs = new String[this.arity];
        this.pronouns = new String[this.numPronouns];
        for (n2 = 0; n2 < this.numPronouns; ++n2) {
            this.pronouns[n2] = bufferedReader.readLine();
        }
        for (n2 = 0; n2 < this.arity; ++n2) {
            this.verbs[n2] = bufferedReader.readLine();
        }
        this.answers = new String[this.arity][];
        for (n2 = 0; n2 < this.arity; ++n2) {
            this.answers[n2] = new String[this.numPronouns];
            for (n = 0; n < this.numPronouns; ++n) {
                this.answers[n2][n] = bufferedReader.readLine();
            }
        }
        n2 = this.getInt(bufferedReader);
        this.boatTypes = new int[n2];
        for (n = 0; n < n2; ++n) {
            this.boatTypes[n] = this.getInt(bufferedReader);
        }
        this.accentsl = bufferedReader.readLine();
        this.wonText = bufferedReader.readLine();
        this.lostText = bufferedReader.readLine();
    }

    boolean getWords(String string) {
        try {
            this.getFromServer(string);
            return true;
        }
        catch (Exception exception) {
            this.hc.error("Communication Fault");
            return false;
        }
    }

    boolean getFromServer(String string) {
        while (!this.getFromServerRetry(string)) {
            try {
                Thread.sleep(2010L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return true;
    }

    boolean getFromServerRetry(String string) {
        try {
            URL uRL = new URL(this.serverName + "gamedata/" + string + "data.txt");
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.setDoInput(true);
            uRLConnection.setUseCaches(false);
            InputStreamReader inputStreamReader = new InputStreamReader(uRLConnection.getInputStream(), "ISO-8859-1");
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            String string2 = bufferedReader.readLine();
            if (!string2.equals("HorseClient")) {
                throw new IOException();
            }
            this.getData(bufferedReader);
            inputStreamReader.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    void getServer() {
        this.serverName = Server.getName(this.hc);
    }
}

